﻿SET statement_timeout = 0;
SET client_encoding = 'UTF8';
--emplazamientos-------------------------
 drop table if EXISTS daicmatbl_location_tipologia cascade;
CREATE table daicmatbl_location_tipologia AS 
SELECT 
  location_has_cdfvalue."Location_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "tipologia"
FROM 
  public.cdfvalue, 
  public.location_has_cdfvalue
WHERE 
  location_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0141-152b35b4c23-365de96-4b-1902';
CREATE OR REPLACE VIEW daicma_gazetteer AS 
SELECT 
  gazetteer.gazetteername AS Departamento, 
  gazetteer_1.gazetteername AS Municipio,
  gazetteer_1.gazetteer_localid as cod_dane_muni, 
  gazetteer.gazetteer_localid as cod_dane_depto, 
  location.location_guid
FROM 
  public.gazetteer, 
  public.gazetteerlevel, 
  public.gazetteer gazetteer_1, 
  public.gazetteerlevel gazetteerlevel_1, 
  public.location
WHERE 
  gazetteer.gazlevel_guid = gazetteerlevel.gazlevel_guid AND
  gazetteer_1.parentgazetteer_guid = gazetteer.gazetteer_guid AND
  gazetteerlevel_1.gazlevel_guid = gazetteer_1.gazlevel_guid AND
  location.gazetteer_guid = gazetteer_1.gazetteer_guid AND
  gazetteerlevel.seqno = 2 AND 
  gazetteerlevel_1.seqno = 3;
CREATE OR REPLACE VIEW daicma_emplazamientos AS 
SELECT
daicma_gazetteer.location_guid,
daicma_gazetteer.Departamento,
daicma_gazetteer.Municipio,
daicma_gazetteer.cod_dane_muni,
daicma_gazetteer.cod_dane_depto,
daicmatbl_location_tipologia.tipologia
FROM
daicma_gazetteer left join daicmatbl_location_tipologia on daicma_gazetteer.location_guid = daicmatbl_location_tipologia."Location_GUID";
--final emplazamientos--------------------------------------------------------------
--traduccion-----------------------------------------------------------------------
CREATE OR REPLACE VIEW daicma_translation AS 
SELECT 
  translation.translation_guid, 
  translation.language, 
  translation.keyvalue, 
  translation.translation
FROM 
  public.translation
WHERE 
  translation.language = 'es';
--final traducción----------------------------------------------------------------------
-- hazard inicio-----------------------------------------------------------------------
drop table if EXISTS daicmatbl_hazard cascade;
CREATE table daicmatbl_hazard AS 
SELECT 
  hazard.hazard_guid, 
  hazard.location_guid, 
  hazard.hazard_localid, 
  hazard.hazardname AS Sitio, 
  hazard.hazarddescription AS Descripcion, 
  hazard.areasize AS "Tamaño del area", 
  hazard.terrainlocalinformation AS "Información del terreno", 
  hazard.isactive, 
  hazard.dataentrydate AS "Fecha de ingreso", 
  hazard.dataenterer, 
  hazard.distancefromnearesttown AS "Distancia a la ciudad mas cercana", 
  hazard.estimatedwidth AS "Ancho estimado", 
  hazard.azimuth, 
  hazard.comments AS Comentarios, 
  hazard.calculated_area AS "Área calculada", 
  hazard.calculated_line_length AS "Largo calculado", 
  hazard.org_guid, 
  imsmaenum.enumvalue AS "Carretera bloqueada", 
  imsmaenum2.enumvalue AS "Agricultura bloqueada", 
  imsmaenum3.enumvalue AS "Infraestructura bloqueada", 
  imsmaenum4.enumvalue AS "Agua bloqueada", 
  imsmaenum5.enumvalue AS Estatus, 
  imsmaenum6.enumvalue AS "Tipo de evento", 
  imsmaenum7.enumvalue AS "Tipo de área", 
  imsmaenum8.enumvalue AS "Tipo de peligro", 
  imsmaenum9.enumvalue AS "Densidad de la vegetacion", 
  imsmaenum10.enumvalue AS "Vegetación removidad por", 
  imsmaenum11.enumvalue AS "Uso de la tierra destinado a"
from
hazard left join imsmaenum on hazard.blockroadsenum_guid = imsmaenum.imsmaenum_guid 
left join imsmaenum imsmaenum2 on hazard.blockagriculturalenum_guid = imsmaenum2.imsmaenum_guid 
left join imsmaenum imsmaenum3 on hazard.blockinfrastructureenum_guid = imsmaenum3.imsmaenum_guid 
left join imsmaenum imsmaenum4 on hazard.blockwaterenum_guid = imsmaenum4.imsmaenum_guid 
left join imsmaenum imsmaenum5 on hazard.status_guid = imsmaenum5.imsmaenum_guid 
left join imsmaenum imsmaenum6 on hazard.dangerousareatype_guid = imsmaenum6.imsmaenum_guid 
left join imsmaenum imsmaenum7 on hazard.areatype_guid = imsmaenum7.imsmaenum_guid 
left join imsmaenum imsmaenum8 on hazard.maareatype_guid = imsmaenum8.imsmaenum_guid 
left join imsmaenum imsmaenum9 on hazard.vegetationdensity_guid = imsmaenum9.imsmaenum_guid
left join imsmaenum imsmaenum10 on hazard.vegetationremovedby_guid = imsmaenum10.imsmaenum_guid
left join imsmaenum imsmaenum11 on hazard.intendedlandused_guid = imsmaenum11.imsmaenum_guid;
--hazard con traducción
drop table if EXISTS daicmatbl_hazard2  cascade;
CREATE table daicmatbl_hazard2 AS 
SELECT 
  daicmatbl_hazard.hazard_guid, 
  daicmatbl_hazard.location_guid, 
  daicmatbl_hazard.hazard_localid, 
  daicmatbl_hazard.sitio, 
  daicmatbl_hazard.descripcion, 
  daicmatbl_hazard."Tamaño del area", 
  daicmatbl_hazard."Información del terreno", 
  daicmatbl_hazard.isactive, 
  daicmatbl_hazard."Fecha de ingreso", 
  daicmatbl_hazard.dataenterer, 
  daicmatbl_hazard."Distancia a la ciudad mas cercana", 
  daicmatbl_hazard."Ancho estimado", 
  daicmatbl_hazard.azimuth, 
  daicmatbl_hazard.comentarios, 
  daicmatbl_hazard."Área calculada", 
  daicmatbl_hazard."Largo calculado", 
  organisation.orgname AS Organización, 
  daicma_translation.translation AS "Carretera bloqueada", 
  daicma_translation2.translation AS "Agricultura bloqueada", 
  daicma_translation3.translation AS "Infraestructura bloqueada", 
  daicma_translation4.translation AS "Agua bloqueada", 
  daicma_translation5.translation AS Estatus, 
  daicma_translation6.translation AS "Tipo de evento", 
  daicma_translation7.translation AS "Tipo de área", 
  daicma_translation8.translation AS "Tipo de peligro", 
  daicma_translation9.translation AS "Densidad de la vegetación", 
  daicma_translation10.translation AS "Vegetación removida por", 
  daicma_translation11.translation AS "Uso destinado de la tierra a",
  daicma_emplazamientos.Departamento, 
  daicma_emplazamientos.Municipio,
  daicma_emplazamientos.tipologia,
  daicma_emplazamientos.cod_dane_muni,
  daicma_emplazamientos.cod_dane_depto
  FROM
daicmatbl_hazard left join organisation on daicmatbl_hazard.org_guid = organisation.org_guid 
left join daicma_translation daicma_translation on daicmatbl_hazard."Carretera bloqueada" = daicma_translation.keyvalue
left join daicma_translation daicma_translation2 on daicmatbl_hazard."Agricultura bloqueada" = daicma_translation2.keyvalue
left join daicma_translation daicma_translation3 on daicmatbl_hazard."Infraestructura bloqueada" = daicma_translation3.keyvalue
left join daicma_translation daicma_translation4 on daicmatbl_hazard."Agua bloqueada" = daicma_translation4.keyvalue
left join daicma_translation daicma_translation5 on daicmatbl_hazard.Estatus = daicma_translation5.keyvalue
left join daicma_translation daicma_translation6 on daicmatbl_hazard."Tipo de evento" = daicma_translation6.keyvalue
left join daicma_translation daicma_translation7 on daicmatbl_hazard."Tipo de área" = daicma_translation7.keyvalue
left join daicma_translation daicma_translation8 on daicmatbl_hazard."Tipo de peligro" = daicma_translation8.keyvalue
left join daicma_translation daicma_translation9 on daicmatbl_hazard."Densidad de la vegetacion" = daicma_translation9.keyvalue
left join daicma_translation daicma_translation10 on daicmatbl_hazard."Vegetación removidad por" = daicma_translation10.keyvalue
left join daicma_translation daicma_translation11 on daicmatbl_hazard."Uso de la tierra destinado a" = daicma_translation11.keyvalue
left join daicma_emplazamientos on daicmatbl_hazard.location_guid = daicma_emplazamientos.location_guid;
-- cdf hazard 
drop table if EXISTS  daicmatbl_hazard_fechaevento  cascade;
CREATE table daicmatbl_hazard_fechaevento AS 
SELECT 
  hazard_has_cdfvalue."Hazard_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.datevalue AS "Fecha del evento"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '0a00-000b-11abcc3d48f-34acff4a-46-f82';
drop table if EXISTS daicmatbl_hazard_coordenadastomadascon  cascade;
CREATE table daicmatbl_hazard_coordenadastomadascon AS 
SELECT 
  hazard_has_cdfvalue."Hazard_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Coordenadas tomadas con"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '0a00-b4ae-12763e81340-aaa57ba6-0-4ff5';
drop table if EXISTS daicmatbl_hazard_presuntoactorresponsable  cascade;
CREATE table daicmatbl_hazard_presuntoactorresponsable AS 
SELECT 
  hazard_has_cdfvalue."Hazard_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Presunto actor responsable"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-11ab6c48a90-8d268ca2-0-dd3c';
-----------------------------------------nuevoapc-------------------------------------
drop table if EXISTS daicmatbl_hazard_criteriosafirmarapcac  cascade;
CREATE table daicmatbl_hazard_criteriosafirmarapcac AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "criterios para afirmar ap ac"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f6e9065-39726e3c-2d-21d';
drop table if EXISTS daicmatbl_hazard_recnaturalesobstaculizados  cascade;
CREATE table daicmatbl_hazard_recnaturalesobstaculizados AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "recursos naturales obstaculizados"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f707c26-baef4f7e-35-bc7';
drop table if EXISTS daicmatbl_hazard_cualrecnaturalesobstaculizados  cascade;
CREATE table daicmatbl_hazard_cualrecnaturalesobstaculizados AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual recursos naturales obstaculizados"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f70e249-dfdbb583-38-146';
drop table if EXISTS daicmatbl_hazard_cualagriculturabloqueada  cascade;
CREATE table daicmatbl_hazard_cualagriculturabloqueada AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual agricultura bloqueada"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f71a169-70f56e68-39-6a8';
drop table if EXISTS daicmatbl_hazard_recmineralesobstaculizados  cascade;
CREATE table daicmatbl_hazard_recmineralesobstaculizados AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "recursos minerales obstaculizados"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f722c64-39b85f1f-3a-132';
drop table if EXISTS daicmatbl_hazard_cualrecmineralesobstaculizados  cascade;
CREATE table daicmatbl_hazard_cualrecmineralesobstaculizados AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual recursos minerales obstaculizados"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f7246e0-1f6038f9-3d-9bc';
drop table if EXISTS daicmatbl_hazard_recsectorindustrialobstaculizado  cascade;
CREATE table daicmatbl_hazard_recsectorindustrialobstaculizado AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "recursos sector industrial obstaculizado"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f749d24-236ddf16-3e-2cf';
drop table if EXISTS daicmatbl_hazard_cualrecsectorindustrialobstaculizado  cascade;
CREATE table daicmatbl_hazard_cualrecsectorindustrialobstaculizado AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual recursos sector industrial obstaculizado"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f74bde9-c40b3d69-41-e22';
drop table if EXISTS daicmatbl_hazard_cualaccesoaguaobstaculizado  cascade;
CREATE table daicmatbl_hazard_cualaccesoaguaobstaculizado AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual acceso agua obstaculizado"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f754574-4a9f316e-42-714';
drop table if EXISTS daicmatbl_hazard_cualinfraestructurabloqueada  cascade;
CREATE table daicmatbl_hazard_cualinfraestructurabloqueada AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual infraestructura bloqueda"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f759b96-b9ef7075-43-1ee';
drop table if EXISTS daicmatbl_hazard_recursospecuariosbloqueados  cascade;
CREATE table daicmatbl_hazard_recursospecuariosbloqueados AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "recursos pecuarios bloqueados"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f7612ff-fedb535-44-ec26';
drop table if EXISTS daicmatbl_hazard_cualrecursospecuariosbloqueados  cascade;
CREATE table daicmatbl_hazard_cualrecursospecuariosbloqueados AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual recursos pecuarios bloqueados"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f762b90-4dca443d-47-93b';
drop table if EXISTS daicmatbl_hazard_cualviasafectadas  cascade;
CREATE table daicmatbl_hazard_cualviasafectadas AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual vias afectadas"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f767564-303c288a-48-3f6';
drop table if EXISTS daicmatbl_hazard_tipodepoblacionoafectada  cascade;
CREATE table daicmatbl_hazard_tipodepoblacionoafectada AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "poblacion afectada"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f772f77-fce1cfbe-49-3ed';
drop table if EXISTS daicmatbl_hazard_cualtipodepoblacionoafectada  cascade;
CREATE table daicmatbl_hazard_cualtipodepoblacionoafectada AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "cual poblacion afectada"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f7746d7-fd407ef5-4c-bc0';
drop table if EXISTS daicmatbl_hazard_numerodemujeres  cascade;
CREATE table daicmatbl_hazard_numerodemujeres AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.numbervalue AS "numero de mujeres"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f77c3aa-274a482-4d-4fca';
drop table if EXISTS daicmatbl_hazard_numerodehombres  cascade;
CREATE table daicmatbl_hazard_numerodehombres AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.numbervalue AS "numero de hombres"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f77e77e-1a7e2f0c-4e-196';
drop table if EXISTS daicmatbl_hazard_numerodeniñas  cascade;
CREATE table daicmatbl_hazard_numerodeniñas AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.numbervalue AS "numero de niñas"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f780889-f42e6865-4f-c32';
drop table if EXISTS daicmatbl_hazard_numerodeniños  cascade;
CREATE table daicmatbl_hazard_numerodeniños AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.numbervalue AS "numero de niños"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4f782c03-948fda0e-50-4bc';
-------------------------------finalnuevoapc--------------------------------------
drop table if EXISTS daicmatbl_hazard_tipodelugar  cascade;
CREATE table daicmatbl_hazard_tipodelugar AS
SELECT distinct on (hazard_has_cdfvalue."Hazard_GUID")
  hazard_has_cdfvalue."Hazard_GUID",
  cdfvalue.stringvalue AS "Tipo de lugar"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-11ab6b7708f-b94593f5-14-401';
drop table if EXISTS daicmatbl_hazard_coordenadas  cascade;
CREATE table daicmatbl_hazard_coordenadas AS
SELECT 
  hazard_has_geospatialinfo.hazard_guid, 
  geopoint.latitude, 
  geopoint.longitude, 
  geopoint.pointtypeenum_guid
FROM 
hazard_has_geospatialinfo left join geopoint on hazard_has_geospatialinfo.geospatialinfo_guid = geopoint.geospatialinfo_guid 
where
geopoint.pointtypeenum_guid = '{BaseData-PointType-00000000000-00001}';
drop table if EXISTS daicmatbl_hazard_fechacambioestatus cascade;
CREATE table  daicmatbl_hazard_fechacambioestatus AS
SELECT 
  hazard_has_cdfvalue."Hazard_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.datevalue AS "Fecha de cambio de estatus"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f5a170e41-a617076f-9-1078';
drop table if EXISTS daicmatbl_hazard_comentariocambioestatus cascade;
CREATE table daicmatbl_hazard_comentariocambioestatus AS
SELECT 
  hazard_has_cdfvalue."Hazard_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Comentario cambio de estatus"
FROM 
  public.cdfvalue, 
  public.hazard_has_cdfvalue
WHERE 
  hazard_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f5a1752eb-b290ee9f-a-50d6';
CREATE OR REPLACE VIEW daicma_hazard_artefactos AS
SELECT 
  hazdeviceinfo.hazard_guid, 
  sum (hazdeviceinfo.qty) as "Cantidad de artefactos"
FROM 
  public.hazdeviceinfo
  group by hazdeviceinfo.hazard_guid;
-- union hazard y cdf
-- union hazard y cdf
drop table if EXISTS daicmatbl_hazard3 cascade;
CREATE table daicmatbl_hazard3 AS
SELECT 
  daicmatbl_hazard2.hazard_guid, 
  daicmatbl_hazard2.hazard_localid, 
  daicmatbl_hazard2.sitio, 
  daicmatbl_hazard2.descripcion, 
  daicmatbl_hazard2."Tamaño del area", 
  daicmatbl_hazard2."Información del terreno", 
  daicmatbl_hazard2.isactive, 
  daicmatbl_hazard2."Fecha de ingreso", 
  daicmatbl_hazard2.dataenterer, 
  daicmatbl_hazard2."Distancia a la ciudad mas cercana", 
  daicmatbl_hazard2."Ancho estimado", 
  daicmatbl_hazard2.azimuth, 
  daicmatbl_hazard2.comentarios, 
  daicmatbl_hazard2."Área calculada", 
  daicmatbl_hazard2."Largo calculado", 
  daicmatbl_hazard2."organización", 
  daicmatbl_hazard2."Carretera bloqueada", 
  daicmatbl_hazard2."Agricultura bloqueada", 
  daicmatbl_hazard2."Infraestructura bloqueada", 
  daicmatbl_hazard2."Agua bloqueada", 
  daicmatbl_hazard2.estatus, 
  daicmatbl_hazard2."Tipo de evento", 
  daicmatbl_hazard2."Tipo de área", 
  daicmatbl_hazard2."Tipo de peligro", 
  daicmatbl_hazard2."Densidad de la vegetación", 
  daicmatbl_hazard2."Vegetación removida por", 
  daicmatbl_hazard2."Uso destinado de la tierra a", 
  daicmatbl_hazard2.departamento, 
  daicmatbl_hazard2.municipio, 
  daicmatbl_hazard2.tipologia, 
  daicmatbl_hazard2.cod_dane_depto,
  daicmatbl_hazard2.cod_dane_muni,
  daicmatbl_hazard_comentariocambioestatus."Comentario cambio de estatus", 
  daicmatbl_hazard_coordenadas.latitude, 
  daicmatbl_hazard_coordenadas.longitude, 
  daicmatbl_hazard_coordenadastomadascon."Coordenadas tomadas con"
FROM
daicmatbl_hazard2 left join daicmatbl_hazard_comentariocambioestatus on daicmatbl_hazard2.hazard_guid = daicmatbl_hazard_comentariocambioestatus."Hazard_GUID"
left join daicmatbl_hazard_coordenadas on daicmatbl_hazard2.hazard_guid = daicmatbl_hazard_coordenadas.hazard_guid
left join daicmatbl_hazard_coordenadastomadascon on daicmatbl_hazard2.hazard_guid = daicmatbl_hazard_coordenadastomadascon."Hazard_GUID";
drop table if EXISTS daicmatbl_hazard_final cascade;
CREATE table daicmatbl_hazard_final AS
SELECT 
  daicmatbl_hazard3.hazard_guid, 
  daicmatbl_hazard3.hazard_localid, 
  daicmatbl_hazard3.sitio, 
  daicmatbl_hazard3.descripcion, 
  daicmatbl_hazard3."Tamaño del area", 
  daicmatbl_hazard3."Información del terreno", 
  daicmatbl_hazard3.isactive, 
  daicmatbl_hazard3."Fecha de ingreso", 
  daicmatbl_hazard3.dataenterer, 
  daicmatbl_hazard3."Distancia a la ciudad mas cercana", 
  daicmatbl_hazard3."Ancho estimado", 
  daicmatbl_hazard3.azimuth, 
  daicmatbl_hazard3.comentarios, 
  daicmatbl_hazard3."Área calculada", 
  daicmatbl_hazard3."Largo calculado", 
  daicmatbl_hazard3."organización", 
  daicmatbl_hazard3."Carretera bloqueada", 
  daicmatbl_hazard3."Agricultura bloqueada", 
  daicmatbl_hazard3."Infraestructura bloqueada", 
  daicmatbl_hazard3."Agua bloqueada", 
  daicmatbl_hazard3.estatus, 
  daicmatbl_hazard3."Tipo de evento", 
  daicmatbl_hazard3."Tipo de área", 
  daicmatbl_hazard3."Tipo de peligro", 
  daicmatbl_hazard3."Densidad de la vegetación", 
  daicmatbl_hazard3."Vegetación removida por", 
  daicmatbl_hazard3."Uso destinado de la tierra a", 
  daicmatbl_hazard3.departamento, 
  daicmatbl_hazard3.municipio,
  daicmatbl_hazard3.tipologia, 
  daicmatbl_hazard3.cod_dane_depto,
  daicmatbl_hazard3.cod_dane_muni,
  daicmatbl_hazard3."Comentario cambio de estatus", 
  daicmatbl_hazard3.latitude, 
  daicmatbl_hazard3.longitude, 
  daicmatbl_hazard3."Coordenadas tomadas con", 
  daicmatbl_hazard_fechacambioestatus."Fecha de cambio de estatus", 
  daicmatbl_hazard_fechaevento."Fecha del evento", 
  daicmatbl_hazard_presuntoactorresponsable."Presunto actor responsable", 
  daicmatbl_hazard_tipodelugar."Tipo de lugar",
  daicma_hazard_artefactos."Cantidad de artefactos"
FROM
daicmatbl_hazard3 left join daicmatbl_hazard_fechacambioestatus on daicmatbl_hazard3.hazard_guid = daicmatbl_hazard_fechacambioestatus."Hazard_GUID"
left join daicmatbl_hazard_fechaevento on daicmatbl_hazard3.hazard_guid = daicmatbl_hazard_fechaevento."Hazard_GUID"
left join daicmatbl_hazard_presuntoactorresponsable on daicmatbl_hazard3.hazard_guid = daicmatbl_hazard_presuntoactorresponsable."Hazard_GUID"
left join daicmatbl_hazard_tipodelugar on daicmatbl_hazard3.hazard_guid = daicmatbl_hazard_tipodelugar."Hazard_GUID"
left join daicma_hazard_artefactos on daicmatbl_hazard3.hazard_guid = daicma_hazard_artefactos.hazard_guid;
CREATE OR REPLACE VIEW daicma_hazard_exp_municipal AS
SELECT 
  daicmatbl_hazard_final.departamento, 
  daicmatbl_hazard_final.municipio,
  daicmatbl_hazard_final.sitio, 
  daicmatbl_hazard_final.hazard_localid AS ID_IMSMA, 
  daicmatbl_hazard_final."Tipo de evento", 
  daicmatbl_hazard_final."Fecha del evento", 
  daicmatbl_hazard_final.latitude, 
  daicmatbl_hazard_final.longitude, 
  daicmatbl_hazard_final."Coordenadas tomadas con", 
  daicmatbl_hazard_final.descripcion AS "descripción del evento", 
  daicmatbl_hazard_final.estatus, 
  daicmatbl_hazard_final."Comentario cambio de estatus", 
  daicmatbl_hazard_final."Fecha de cambio de estatus", 
  daicmatbl_hazard_final."organización" AS fuente,
  daicmatbl_hazard_final.hazard_guid
FROM 
  public.daicmatbl_hazard_final
WHERE 
  daicmatbl_hazard_final."Tipo de evento" IS NOT NULL ;
CREATE OR REPLACE VIEW daicma_hazard_incidentes AS
SELECT 
  daicmatbl_hazard_final."Tipo de evento", 
  daicmatbl_hazard_final.departamento, 
  daicmatbl_hazard_final.municipio, 
  daicmatbl_hazard_final.tipologia, 
  daicmatbl_hazard_final.sitio, 
  daicmatbl_hazard_final."Fecha del evento", 
  daicmatbl_hazard_final."Coordenadas tomadas con", 
  daicmatbl_hazard_final.latitude, 
  daicmatbl_hazard_final.longitude, 
  daicmatbl_hazard_final.cod_dane_depto, 
  daicmatbl_hazard_final.cod_dane_muni, 
  daicmatbl_hazard_final."Tipo de lugar", 
  daicmatbl_hazard_final."Presunto actor responsable", 
  daicmatbl_hazard_final.descripcion, 
  daicmatbl_hazard_final."Tipo de área", 
  daicmatbl_hazard_final.hazard_localid AS "id_imsma evento", 
  daicmatbl_hazard_final.estatus, 
  daicmatbl_hazard_final.hazard_guid,
  daicmatbl_hazard_final."Cantidad de artefactos"
FROM 
  public.daicmatbl_hazard_final
WHERE 
  daicmatbl_hazard_final."Tipo de evento" IS NOT NULL ;
CREATE OR REPLACE VIEW daicma_hazard_operaciones_desminado AS
SELECT 
  daicmatbl_hazard_final.departamento, 
  daicmatbl_hazard_final.municipio, 
  daicmatbl_hazard_final.tipologia, 
  daicmatbl_hazard_final.sitio, 
  daicmatbl_hazard_final.hazard_guid, 
  daicmatbl_hazard_final.hazard_localid AS Id_imsma, 
  daicmatbl_hazard_final."Tamaño del area", 
  daicmatbl_hazard_final.descripcion, 
  daicmatbl_hazard_final."Fecha del evento", 
  daicmatbl_hazard_final."organización", 
  daicmatbl_hazard_final."Tipo de peligro",
  daicmatbl_hazard_final."Carretera bloqueada", 
  daicmatbl_hazard_final."Agricultura bloqueada", 
  daicmatbl_hazard_final."Infraestructura bloqueada", 
  daicmatbl_hazard_final."Agua bloqueada" 
FROM 
  daicmatbl_hazard_final
WHERE 
  daicmatbl_hazard_final."Tipo de evento" IS NULL ;
CREATE OR REPLACE VIEW daicma_hazard_operaciones_desminado_completo AS
SELECT
daicma_hazard_operaciones_desminado.departamento, 
  daicma_hazard_operaciones_desminado.municipio, 
  daicma_hazard_operaciones_desminado.tipologia, 
  daicma_hazard_operaciones_desminado.sitio, 
  daicma_hazard_operaciones_desminado.hazard_guid, 
  daicma_hazard_operaciones_desminado.Id_imsma, 
  daicma_hazard_operaciones_desminado."Tamaño del area", 
  daicma_hazard_operaciones_desminado.descripcion, 
  daicma_hazard_operaciones_desminado."Fecha del evento", 
  daicma_hazard_operaciones_desminado."organización", 
  daicma_hazard_operaciones_desminado."Tipo de peligro",
  daicma_hazard_operaciones_desminado."Carretera bloqueada", 
  daicma_hazard_operaciones_desminado."Agricultura bloqueada", 
  daicma_hazard_operaciones_desminado."Infraestructura bloqueada", 
  daicma_hazard_operaciones_desminado."Agua bloqueada", 
daicmatbl_hazard_criteriosafirmarapcac."criterios para afirmar ap ac",
daicmatbl_hazard_recnaturalesobstaculizados."recursos naturales obstaculizados",
daicmatbl_hazard_cualrecnaturalesobstaculizados."cual recursos naturales obstaculizados",
daicmatbl_hazard_cualagriculturabloqueada."cual agricultura bloqueada",
daicmatbl_hazard_recmineralesobstaculizados."recursos minerales obstaculizados",
daicmatbl_hazard_cualrecmineralesobstaculizados."cual recursos minerales obstaculizados",
daicmatbl_hazard_recsectorindustrialobstaculizado."recursos sector industrial obstaculizado",
daicmatbl_hazard_cualrecsectorindustrialobstaculizado."cual recursos sector industrial obstaculizado",
daicmatbl_hazard_cualaccesoaguaobstaculizado."cual acceso agua obstaculizado",
daicmatbl_hazard_cualinfraestructurabloqueada."cual infraestructura bloqueda",
daicmatbl_hazard_recursospecuariosbloqueados."recursos pecuarios bloqueados",
daicmatbl_hazard_cualrecursospecuariosbloqueados."cual recursos pecuarios bloqueados",
daicmatbl_hazard_cualviasafectadas."cual vias afectadas",
daicmatbl_hazard_tipodepoblacionoafectada."poblacion afectada",
daicmatbl_hazard_cualtipodepoblacionoafectada."cual poblacion afectada",
daicmatbl_hazard_numerodemujeres."numero de mujeres",
daicmatbl_hazard_numerodehombres."numero de hombres" ,
daicmatbl_hazard_numerodeniñas."numero de niñas",
daicmatbl_hazard_numerodeniños."numero de niños"
FROM
daicma_hazard_operaciones_desminado 
left join daicmatbl_hazard_criteriosafirmarapcac on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_criteriosafirmarapcac."Hazard_GUID"
left join daicmatbl_hazard_recnaturalesobstaculizados on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_recnaturalesobstaculizados."Hazard_GUID"
left join daicmatbl_hazard_cualrecnaturalesobstaculizados on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualrecnaturalesobstaculizados."Hazard_GUID"
left join daicmatbl_hazard_cualagriculturabloqueada on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualagriculturabloqueada."Hazard_GUID"
left join daicmatbl_hazard_recmineralesobstaculizados on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_recmineralesobstaculizados."Hazard_GUID"
left join daicmatbl_hazard_cualrecmineralesobstaculizados on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_criteriosafirmarapcac."Hazard_GUID"
left join daicmatbl_hazard_recsectorindustrialobstaculizado on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_recsectorindustrialobstaculizado."Hazard_GUID"
left join daicmatbl_hazard_cualrecsectorindustrialobstaculizado on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualrecsectorindustrialobstaculizado."Hazard_GUID"
left join daicmatbl_hazard_cualaccesoaguaobstaculizado on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualaccesoaguaobstaculizado."Hazard_GUID"
left join daicmatbl_hazard_cualinfraestructurabloqueada on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualinfraestructurabloqueada."Hazard_GUID"
left join daicmatbl_hazard_recursospecuariosbloqueados on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_recursospecuariosbloqueados."Hazard_GUID"
left join daicmatbl_hazard_cualrecursospecuariosbloqueados on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualrecursospecuariosbloqueados."Hazard_GUID"
left join daicmatbl_hazard_cualviasafectadas on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualviasafectadas."Hazard_GUID"
left join daicmatbl_hazard_tipodepoblacionoafectada on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_tipodepoblacionoafectada."Hazard_GUID"
left join daicmatbl_hazard_cualtipodepoblacionoafectada on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_cualtipodepoblacionoafectada."Hazard_GUID"
left join daicmatbl_hazard_numerodemujeres on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_numerodemujeres."Hazard_GUID"
left join daicmatbl_hazard_numerodehombres on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_numerodehombres."Hazard_GUID"
left join daicmatbl_hazard_numerodeniñas on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_numerodeniñas."Hazard_GUID"
left join daicmatbl_hazard_numerodeniños on daicma_hazard_operaciones_desminado.hazard_guid = daicmatbl_hazard_numerodeniños."Hazard_GUID";
-- final consultas hazard-------------------------------------------------------
-- accidentes incio ------------------------------------------------------------
drop table if EXISTS daicmatbl_accident  cascade;
CREATE table daicmatbl_accident AS
SELECT 
  accident.accident_guid, 
  daicma_emplazamientos.departamento, 
  daicma_emplazamientos.municipio, 
  daicma_emplazamientos.tipologia,
  daicma_emplazamientos.cod_dane_muni,
  daicma_emplazamientos.cod_dane_depto,
  accident.dateofaccident AS "Fecha del accidente", 
  accident.isactive, 
  accident.dataentrydate, 
  accident.dataenterer, 
  accident.accidentdescription, 
  imsmaenum2.enumvalue AS "Tipo de area", 
  accident.accident_localid AS "id_imsma evento",
  accident.municipality
FROM
accident left join daicma_emplazamientos on accident.location_guid = daicma_emplazamientos.location_guid
left join imsmaenum imsmaenum2 on accident.areatype_guid = imsmaenum2.imsmaenum_guid;
-- cdf accidente
drop table if EXISTS daicmatbl_accident_coordenadastomadascon  cascade;
CREATE table daicmatbl_accident_coordenadastomadascon AS 
SELECT 
  accident_has_cdfvalue."Accident_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Coordenadas tomadas con"
FROM 
  public.cdfvalue, 
  public.accident_has_cdfvalue
WHERE 
  accident_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '0a00-b4ae-1276408d9f0-fb6e549e-15-dc5';
  drop table if EXISTS daicmatbl_accident_presuntoactorresponsable  cascade;
CREATE table daicmatbl_accident_presuntoactorresponsable AS 
SELECT 
  accident_has_cdfvalue."Accident_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Presunto actor responsable"
FROM 
  public.cdfvalue, 
  public.accident_has_cdfvalue
WHERE 
  accident_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0141-14a88959b1b-cb6d526e-10-836';
  drop table if EXISTS daicmatbl_accident_tipodelugar  cascade;
CREATE table daicmatbl_accident_tipodelugar AS 
SELECT distinct on (accident_has_cdfvalue."Accident_GUID")
  accident_has_cdfvalue."Accident_GUID", 
  cdfvalue.stringvalue AS "Tipo de lugar"
FROM 
  public.cdfvalue, 
  public.accident_has_cdfvalue
WHERE 
  accident_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-11ab6ebca99-cdfddad1-89-6e3';
  drop table if EXISTS daicmatbl_accident_artefactocausando cascade;
CREATE table daicmatbl_accident_artefactocausando AS 
SELECT 
  accident_has_cdfvalue."Accident_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Artefacto Causando Accidente"
FROM 
  public.cdfvalue, 
  public.accident_has_cdfvalue
WHERE 
  accident_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '0a0a-502c-11aa0c291da-4e832906-d-c90a';
drop table if EXISTS daicmatbl_accident_coordenadas cascade;
CREATE table daicmatbl_accident_coordenadas AS
SELECT 
  accident_has_geospatialinfo.accident_guid, 
  geopoint.latitude, 
  geopoint.longitude, 
  geopoint.pointtypeenum_guid
FROM 
accident_has_geospatialinfo left join geopoint on accident_has_geospatialinfo.geospatialinfo_guid = geopoint.geospatialinfo_guid
where
geopoint.pointtypeenum_guid = '{BaseData-PointType-00000000000-00001}';
drop table if EXISTS daicmatbl_accident_final cascade;
CREATE table daicmatbl_accident_final AS
SELECT 
  daicmatbl_accident.accident_guid, 
  daicmatbl_accident.departamento, 
  daicmatbl_accident.municipio, 
  daicmatbl_accident.tipologia,
  daicmatbl_accident."Fecha del accidente", 
  daicmatbl_accident.isactive, 
  daicmatbl_accident.dataentrydate, 
  daicmatbl_accident.dataenterer, 
  daicmatbl_accident.accidentdescription AS Descripción, 
  daicmatbl_accident."id_imsma evento", 
  daicmatbl_accident_artefactocausando."Artefacto Causando Accidente" as "tipo de accidente", 
  daicmatbl_accident_coordenadas.latitude, 
  daicmatbl_accident_coordenadas.longitude, 
  daicmatbl_accident_coordenadastomadascon."Coordenadas tomadas con", 
  daicmatbl_accident_presuntoactorresponsable."Presunto actor responsable", 
  daicmatbl_accident_tipodelugar."Tipo de lugar", 
  daicmatbl_accident.cod_dane_muni, 
  daicmatbl_accident.cod_dane_depto,  
  daicma_translation1.translation AS "Tipo de área",
  daicmatbl_accident.municipality as sitio
FROM
daicmatbl_accident left join daicma_translation daicma_translation1 on daicmatbl_accident."Tipo de area" = daicma_translation1.keyvalue
left join daicmatbl_accident_artefactocausando on daicmatbl_accident."accident_guid" = daicmatbl_accident_artefactocausando."Accident_GUID"
left join daicmatbl_accident_coordenadas on daicmatbl_accident.accident_guid = daicmatbl_accident_coordenadas.accident_guid
left join daicmatbl_accident_coordenadastomadascon on daicmatbl_accident.accident_guid =  daicmatbl_accident_coordenadastomadascon."Accident_GUID"
left join daicmatbl_accident_presuntoactorresponsable on daicmatbl_accident.accident_guid = daicmatbl_accident_presuntoactorresponsable."Accident_GUID"
left join daicmatbl_accident_tipodelugar on daicmatbl_accident.accident_guid = daicmatbl_accident_tipodelugar."Accident_GUID";
--final consultas accident-----------------------------------------------------------------------
--inicio hazarreduc------------------------------------------------------------------------------
drop table if EXISTS daicmatbl_hazreduc_idsospechasrelacionadas cascade;
CREATE table  daicmatbl_hazreduc_idsospechasrelacionadas AS
SELECT 
  hazreduc_has_cdfvalue."HazReduc_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "id sospechas relacionadas"
FROM 
  public.cdfvalue, 
  public.hazreduc_has_cdfvalue
WHERE 
  hazreduc_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4fb91bae-7a3ed947-53-4ff';
---------------------nuevo---------------------------------------------------------
drop table if EXISTS daicmatbl_hazreduc_antecedentesent cascade;
CREATE table  daicmatbl_hazreduc_antecedentesent AS
SELECT 
  hazreduc_has_cdfvalue."HazReduc_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "antecedentes ent"
FROM 
  public.cdfvalue, 
  public.hazreduc_has_cdfvalue
WHERE 
  hazreduc_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4fb9c113-ffe7b0af-54-3ec';
drop table if EXISTS daicmatbl_hazreduc_idsentrelacionados cascade;
CREATE table  daicmatbl_hazreduc_idsentrelacionados AS
SELECT 
  hazreduc_has_cdfvalue."HazReduc_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "id ent relacionados"
FROM 
  public.cdfvalue, 
  public.hazreduc_has_cdfvalue
WHERE 
  hazreduc_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4fc6a067-b74b2bb6-55-5b7';
drop table if EXISTS daicmatbl_hazreduc_tamañoareacancelada cascade;
CREATE table  daicmatbl_hazreduc_tamañoareacancelada AS
SELECT 
  hazreduc_has_cdfvalue."HazReduc_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "tamaño area cancelada"
FROM 
  public.cdfvalue, 
  public.hazreduc_has_cdfvalue
WHERE 
  hazreduc_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4fcf9ab9-3a555f1c-57-6c9';
drop table if EXISTS daicmatbl_hazreduc_areabarridaet cascade;
CREATE table  daicmatbl_hazreduc_areabarridaet AS
SELECT 
  hazreduc_has_cdfvalue."HazReduc_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "area barrida ET"
FROM 
  public.cdfvalue, 
  public.hazreduc_has_cdfvalue
WHERE 
  hazreduc_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4fcf1029-66318939-56-5f6';
drop table if EXISTS daicmatbl_hazreduc_tamañoareaet cascade;
CREATE table  daicmatbl_hazreduc_tamañoareaet AS
SELECT 
  hazreduc_has_cdfvalue."HazReduc_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "tamaño area et"
FROM 
  public.cdfvalue, 
  public.hazreduc_has_cdfvalue
WHERE 
  hazreduc_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4fe82e3a-78753a98-59-6a2';
drop table if EXISTS daicmatbl_hazreduc_idsetrelacionados cascade;
CREATE table  daicmatbl_hazreduc_idsetrelacionados AS
SELECT 
  hazreduc_has_cdfvalue."HazReduc_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "id et relacionados"
FROM 
  public.cdfvalue, 
  public.hazreduc_has_cdfvalue
WHERE 
  hazreduc_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0ddb-12f4fe7c2ff-1c5c6492-58-901';
drop table if EXISTS daicmatbl_hazreduc cascade;
CREATE table  daicmatbl_hazreduc AS
SELECT 
  hazreduc.hazreduc_guid, 
  hazreduc.hazreduc_localid, 
  hazreduc.org_guid, 
  hazreduc.org_input, 
  hazreduc.hazreducname, 
  imsmaenum.enumvalue AS "Tipo de operación", 
  hazreduc.startdate AS "Fecha de inicio", 
  hazreduc.enddate AS "Fecha finalizacion", 
  hazreduc.operationalnotes AS "Notas operacionales", 
  hazreduc.areasize AS "Tamaño del área", 
  hazreduc.isactive, 
  hazreduc.dataentrydate, 
  hazreduc.dataenterer, 
  hazreduc.areadescription AS "descripcion", 
  hazreduc.sopmanual AS "sop manual", 
  hazreduc.sopmechanical AS "sop mecanica", 
  hazreduc.sopcombination AS "sop combinada", 
  hazreduc.qacomments AS comentario, 
  hazreduc.verificationnotes, 
  hazreduc.calculated_area, 
  hazreduc.vegetationremoval_area_description, 
  daicma_emplazamientos.departamento, 
  daicma_emplazamientos.municipio,
daicma_emplazamientos.tipologia,
daicma_emplazamientos.cod_dane_muni,
daicma_emplazamientos.cod_dane_depto
FROM
hazreduc left join imsmaenum on hazreduc.hazreductypeenum_guid = imsmaenum.imsmaenum_guid
left join daicma_emplazamientos on hazreduc.location_guid = daicma_emplazamientos.location_guid;
drop table if EXISTS daicmatbl_hazreduc_coordenadas cascade;
CREATE table daicmatbl_hazreduc_coordenadas AS
SELECT 
  hazreduc_has_geospatialinfo.hazreduc_guid, 
  geopoint.latitude, 
  geopoint.longitude, 
  geopoint.pointtypeenum_guid
FROM 
hazreduc_has_geospatialinfo left join geopoint on hazreduc_has_geospatialinfo.geospatialinfo_guid = geopoint.geospatialinfo_guid 
where
geopoint.pointtypeenum_guid = '{BaseData-PointType-00000000000-00001}';
CREATE OR REPLACE VIEW daicma_dh_artefactos AS
SELECT 
  hazreducdeviceinfo.hazreduc_guid,
  ordnance.model, 
  Sum (hazreducdeviceinfo.qty) as "Cantida de artefactos"
FROM 
  public.hazreducdeviceinfo, 
  public.ordnance
WHERE 
  hazreducdeviceinfo.ordnance_guid = ordnance.ordnance_guid
  group by  hazreducdeviceinfo.hazreduc_guid, ordnance.model;
drop table if EXISTS daicmatbl_artefactos_dh2 cascade;
CREATE TABLE daicmatbl_artefactos_dh2
(
  hazreduc_guid character varying(38),
  map numeric(21,0),
  muse numeric(21,0)
);
insert into daicmatbl_artefactos_dh2
(
  hazreduc_guid,
map
)
SELECT 
  daicma_dh_artefactos."hazreduc_guid", 
  daicma_dh_artefactos."Cantida de artefactos"
FROM 
  public.daicma_dh_artefactos
WHERE 
   daicma_dh_artefactos.model = 'Cilindro de Gaz, abandonado' OR
    daicma_dh_artefactos.model = 'CLAYMORE TYPE' OR
     daicma_dh_artefactos.model = 'Hechiza desconocida' OR
      daicma_dh_artefactos.model = 'IM-MN-MAP-1 Explosiva' OR
       daicma_dh_artefactos.model = 'Kleymore' OR
        daicma_dh_artefactos.model = 'M-16' OR
         daicma_dh_artefactos.model = 'Quiebrapata' OR
          daicma_dh_artefactos.model = 'Sombrero Chino' OR
           daicma_dh_artefactos.model = 'Sopro-Explosiva' OR
            daicma_dh_artefactos.model = 'Tipo Abanico' OR
             daicma_dh_artefactos.model = 'tipo balon' OR
              daicma_dh_artefactos.model = 'Tipo Cajón' OR
              daicma_dh_artefactos.model = 'Unknown anti-personnel mine' OR
              daicma_dh_artefactos.model = 'Unknown landmine' OR
              daicma_dh_artefactos.model = 'Unknown misc. explosive device';
insert into daicmatbl_artefactos_dh2
(
  hazreduc_guid,
muse
)
SELECT 
  daicma_dh_artefactos."hazreduc_guid", 
  daicma_dh_artefactos."Cantida de artefactos"
FROM 
  public.daicma_dh_artefactos
WHERE 
   daicma_dh_artefactos.model = 'Unknown grenade' OR
    daicma_dh_artefactos.model = 'Unknown guided missile' OR
     daicma_dh_artefactos.model = 'Unknown other UXO';
CREATE OR REPLACE VIEW daicma_dh_artefactos_final AS
SELECT 
  daicmatbl_artefactos_dh2.hazreduc_guid, 
  sum (daicmatbl_artefactos_dh2.map) as MAP, 
  sum (daicmatbl_artefactos_dh2.muse) as MUSE
FROM 
  public.daicmatbl_artefactos_dh2
  group by  daicmatbl_artefactos_dh2.hazreduc_guid;
drop table if EXISTS daicmatbl_hazreduc_final cascade;
CREATE table  daicmatbl_hazreduc_final AS
SELECT 
  daicmatbl_hazreduc.hazreduc_guid, 
  daicmatbl_hazreduc.hazreduc_localid, 
  daicmatbl_hazreduc.departamento, 
  daicmatbl_hazreduc.municipio, 
daicmatbl_hazreduc.tipologia,
 daicma_translation.translation AS "Tipo de operación", 
  organisation.orgname AS Organización, 
  daicmatbl_hazreduc.hazreducname as "Nombre Reducción", 
  daicmatbl_hazreduc."Fecha de inicio" as "Fecha de la Operacion", 
  daicmatbl_hazreduc."Fecha finalizacion", 
  daicmatbl_hazreduc."Tamaño del área", 
  daicmatbl_hazreduc."Notas operacionales", 
 "daicmatbl_hazreduc_areabarridaet"."area barrida ET",
  "daicmatbl_hazreduc_tamañoareacancelada"."tamaño area cancelada", 
  daicma_dh_artefactos_final.MAP,
  daicma_dh_artefactos_final.MUSE,
  daicmatbl_hazreduc.descripcion, 
  daicmatbl_hazreduc."sop manual", 
  daicmatbl_hazreduc."sop mecanica", 
  daicmatbl_hazreduc."sop combinada", 
  daicmatbl_hazreduc.comentario, 
  daicmatbl_hazreduc.verificationnotes,
  daicmatbl_hazreduc_idsentrelacionados."id ent relacionados", 
  daicmatbl_hazreduc_idsetrelacionados."id et relacionados", 
  daicmatbl_hazreduc_idsospechasrelacionadas."id sospechas relacionadas", 
  daicmatbl_hazreduc_coordenadas.latitude, 
  daicmatbl_hazreduc_coordenadas.longitude,
   daicmatbl_hazreduc_antecedentesent."antecedentes ent",
   daicmatbl_hazreduc.cod_dane_muni, 
  daicmatbl_hazreduc.cod_dane_depto
FROM
daicmatbl_hazreduc left join daicmatbl_hazreduc_areabarridaet on daicmatbl_hazreduc.hazreduc_guid = daicmatbl_hazreduc_areabarridaet."HazReduc_GUID"
left join daicmatbl_hazreduc_coordenadas on daicmatbl_hazreduc.hazreduc_guid = daicmatbl_hazreduc_coordenadas.hazreduc_guid
left join daicmatbl_hazreduc_idsentrelacionados on daicmatbl_hazreduc.hazreduc_guid = daicmatbl_hazreduc_idsentrelacionados."HazReduc_GUID"
left join daicmatbl_hazreduc_idsetrelacionados on daicmatbl_hazreduc.hazreduc_guid = daicmatbl_hazreduc_idsetrelacionados."HazReduc_GUID"
left join daicmatbl_hazreduc_antecedentesent on daicmatbl_hazreduc.hazreduc_guid = daicmatbl_hazreduc_antecedentesent."HazReduc_GUID"
left join daicmatbl_hazreduc_idsospechasrelacionadas on daicmatbl_hazreduc.hazreduc_guid = daicmatbl_hazreduc_idsospechasrelacionadas."HazReduc_GUID"
left join "daicmatbl_hazreduc_tamañoareacancelada" on daicmatbl_hazreduc.hazreduc_guid = "daicmatbl_hazreduc_tamañoareacancelada"."HazReduc_GUID"
left join organisation on daicmatbl_hazreduc.org_guid = organisation.org_guid
left join daicma_translation on daicmatbl_hazreduc."Tipo de operación" = daicma_translation.keyvalue
left join daicma_dh_artefactos_final on daicmatbl_hazreduc.hazreduc_guid  = daicma_dh_artefactos_final.hazreduc_guid 
where daicma_translation.translation not like 'Desminado de Emergencia' and
daicma_translation.translation not like 'Destrucción' and
daicma_translation.translation is not null ;
ALTER TABLE daicmatbl_hazreduc_final ADD COLUMN "Tipo de desminado" text;
UPDATE daicmatbl_hazreduc_final
   SET "Tipo de desminado"='Bases Militares'
 WHERE "Nombre Reducción" like '%Base Militar%';
UPDATE daicmatbl_hazreduc_final
   SET "Tipo de desminado"='Comunidades'
 WHERE "Tipo de desminado" is null;
drop table if EXISTS daicmatbl_link_hazreduc_hazard cascade;
CREATE table  daicmatbl_link_hazreduc_hazard AS
SELECT 
  link.link_guid, 
  link.approval_state, 
  link.from_guid AS hazreduc_guid, 
  link.from_link_type, 
  link.to_guid AS hazard_guid, 
  link.to_link_type
FROM 
  public.link
WHERE 
  link.approval_state = 'APPROVED' AND 
  link.from_link_type = 'HAZARD_REDUCTION' AND 
  link.to_link_type = 'HAZARD';
drop table if EXISTS daicmatbl_link_hazard_hazreduc cascade;
CREATE table  daicmatbl_link_hazard_hazreduc AS
SELECT 
  link.link_guid, 
  link.approval_state, 
  link.from_guid AS hazard_guid, 
  link.from_link_type, 
  link.to_guid AS hazreduc_guid,
  link.to_link_type
FROM 
  public.link
WHERE 
  link.approval_state = 'APPROVED' AND 
  link.from_link_type =  'HAZARD' AND 
  link.to_link_type = 'HAZARD_REDUCTION';
CREATE OR REPLACE VIEW daicma_dh_ent_sospechas AS
SELECT 
  daicmatbl_hazreduc_final.departamento, 
  daicmatbl_hazreduc_final.municipio, 
daicmatbl_hazreduc_final.tipologia,   
  daicmatbl_hazreduc_final.hazreduc_localid, 
  daicmatbl_hazreduc_final.Organización, 
  daicmatbl_hazreduc_final."Tipo de operación",
  daicmatbl_hazreduc_final."Nombre Reducción", 
  daicmatbl_hazreduc_final."Fecha de la Operacion", 
  daicmatbl_hazreduc_final.MAP,
  daicmatbl_hazreduc_final. MUSE,
  daicmatbl_hazreduc_final."antecedentes ent",
  daicma_hazard_exp_municipal.id_imsma, 
  daicma_hazard_exp_municipal."Tipo de evento", 
  daicma_hazard_exp_municipal."Fecha del evento",
  daicma_hazard_exp_municipal.estatus
  FROM
(daicmatbl_hazreduc_final left join daicmatbl_link_hazreduc_hazard on daicmatbl_hazreduc_final.hazreduc_guid = daicmatbl_link_hazreduc_hazard.hazreduc_guid)  
left join daicma_hazard_exp_municipal on daicmatbl_link_hazreduc_hazard.hazard_guid = daicma_hazard_exp_municipal.hazard_guid
where daicmatbl_hazreduc_final."Tipo de operación" = 'Estudio No Técnico'AND
daicma_hazard_exp_municipal.id_imsma IS NOT NULL;
--Final Operaciones dh----------------------------------------------------------------------------------------
--Inicio víctimas---------------------------------------------------------------------------------------------
drop table if EXISTS daicmatbl_victim cascade;
CREATE table  daicmatbl_victim AS
SELECT 
  victim.familyname AS "apellidos", 
  victim.givenname AS "nombres", 
  victim.nationalid AS "numero de identificación", 
  victim.address AS "direccion", 
  victim.dateofbirth AS "fecha de nacimiento", 
  imsmaenum.enumvalue AS "condicion", 
  imsmaenum1.enumvalue AS "genero", 
  imsmaenum2.enumvalue AS "estado", 
  victim.activityataccother AS "otra actividad", 
  victim.medicalreportreference AS "reporte medico", 
  victim.victim_guid, 
  victim.victim_localid AS id_imsma_victima, 
  imsmaenum3.enumvalue AS "actividad"
FROM
victim left join imsmaenum on victim.status_guid = imsmaenum.imsmaenum_guid
left join imsmaenum imsmaenum1 on victim.genderenum_guid = imsmaenum1.imsmaenum_guid
left join imsmaenum imsmaenum2 on victim.killedorinjuredenum_guid = imsmaenum2.imsmaenum_guid
left join imsmaenum imsmaenum3 on victim.activityataccenum_guid = imsmaenum3.imsmaenum_guid;
--cdf victimas---------------------------------------------------
drop table if EXISTS daicmatbl_victim_tipodocumento cascade;
CREATE table  daicmatbl_victim_tipodocumento AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "tipo de documento"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-11ab768b7cc-b6c2f7c2-10-d87';
drop table if EXISTS daicmatbl_victim_otrotipodocumento cascade;
CREATE table  daicmatbl_victim_otrotipodocumento AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "otro tipo de documento"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'c0a8-0203-11b226ba48e-bd2cc1e2-44-2b2';
drop table if EXISTS daicmatbl_victim_telefonocontacto cascade;
CREATE table  daicmatbl_victim_telefonocontacto AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "telefono de contacto"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'c0a8-0069-120f2d41215-96e759f1-2-69ae';
drop table if EXISTS daicmatbl_victim_rangoedad cascade;
CREATE table  daicmatbl_victim_rangoedad AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "rango de edad"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '0a0a-502c-11aa1c7958d-5f485dfd-379cb-';
--------------------------------------------------------------------
drop table if EXISTS daicmatbl_victim_fuezapertenece cascade;
CREATE table  daicmatbl_victim_fuezapertenece AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Fueza publica pertenece"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '0a00-b73e-11c9bd05497-94408cc4-0-982b';
drop table if EXISTS daicmatbl_victim_pertenenciagrupoetnico cascade;
CREATE table  daicmatbl_victim_pertenenciagrupoetnico AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "pertenencia a un grupo etnico"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'c0a8-0203-11b226a5e53-8b18a414-38-94c';
drop table if EXISTS daicmatbl_victim_etnia cascade;
CREATE table  daicmatbl_victim_etnia AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "etnia"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '0a00-b73e-11c9a652a41-2db1c728-0-602d';
drop table if EXISTS daicmatbl_victim_comunidad cascade;
CREATE table  daicmatbl_victim_comunidad AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "comunidad"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cad3bcff7-cca097f0-23-dd8';
drop table if EXISTS daicmatbl_victim_resguardoconsejocomunitario cascade;
CREATE table  daicmatbl_victim_resguardoconsejocomunitario AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "resguardo consejo comunitario"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cad3ba378-91ea5e00-22-609';
drop table if EXISTS daicmatbl_victim_verificadoregistraduria cascade;
CREATE table  daicmatbl_victim_verificadoregistraduria AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.datevalue AS "verificado registraduria"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = 'ac10-0141-1508064b635-bc4b6403-1-7356';
drop table if EXISTS daicmatbl_victim_amputacionfinal cascade;
CREATE table  daicmatbl_victim_amputacionfinal AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "amputación-pérdida final"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacada8da-ceb5baf2-5-6ac0';
drop table if EXISTS daicmatbl_victim_amputacioninicial cascade;
CREATE table  daicmatbl_victim_amputacioninicial AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "amputación-pérdida inicial"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacad59c0-670c4277-2-80de';
drop table if EXISTS daicmatbl_victim_afectacionauditiva cascade;
CREATE table  daicmatbl_victim_afectacionauditiva AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "afectación auditiva"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacb03c08-a3fe390c-1a-45f';
drop table if EXISTS daicmatbl_victim_afectacionvisual cascade;
CREATE table  daicmatbl_victim_afectacionvisual AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "afectación visual"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacafc205-ef9a4204-17-3c1';
drop table if EXISTS daicmatbl_victim_esquirla cascade;
CREATE table  daicmatbl_victim_esquirla AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS esquirla
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacade68f-4c37b644-8-9fb5';
drop table if EXISTS daicmatbl_victim_fractura cascade;
CREATE table  daicmatbl_victim_fractura AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS fractura
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacaef511-73c8180b-e-2c61';
drop table if EXISTS daicmatbl_victim_heridaslaceraciones cascade;
CREATE table  daicmatbl_victim_heridaslaceraciones AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS "Heridas-laceraciones"
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacaf783b-7d03c50d-14-734';
drop table if EXISTS daicmatbl_victim_infeccion cascade;
CREATE table  daicmatbl_victim_infeccion AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS infeccion
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacaf3853-238fbc36-11-790';
drop table if EXISTS daicmatbl_victim_quemadura cascade;
CREATE table  daicmatbl_victim_quemadura AS
SELECT 
  victim_has_cdfvalue."Victim_GUID", 
  cdfvalue.cdf_id, 
  cdfvalue.stringvalue AS quemadura
FROM 
  public.cdfvalue, 
  public.victim_has_cdfvalue
WHERE 
  victim_has_cdfvalue."CDFValue_GUID" = cdfvalue.cdfvalue_guid AND
  cdfvalue.cdf_id = '7f00-0001-12cacaf3853-238fbc36-11-790';
drop table if EXISTS daicmatbl_victim2 cascade;
CREATE table  daicmatbl_victim2 AS
SELECT 
  daicmatbl_victim.apellidos, 
  daicmatbl_victim.nombres, 
  daicmatbl_victim."numero de identificación", 
  daicmatbl_victim.direccion, 
  daicmatbl_victim."fecha de nacimiento", 
  daicma_translation.translation AS "condicion", 
  daicma_translation1.translation AS "genero", 
  daicma_translation2.translation AS "estado", 
  daicmatbl_victim."otra actividad", 
  daicmatbl_victim."reporte medico", 
  daicmatbl_victim.victim_guid, 
  daicmatbl_victim.id_imsma_victima, 
  daicma_translation3.translation AS "actividad",
daicmatbl_victim_amputacionfinal."amputación-pérdida final",
daicmatbl_victim_amputacioninicial."amputación-pérdida inicial",
daicmatbl_victim_afectacionauditiva."afectación auditiva",
daicmatbl_victim_afectacionvisual."afectación visual",
daicmatbl_victim_esquirla.esquirla,
daicmatbl_victim_fractura.fractura,
daicmatbl_victim_heridaslaceraciones."Heridas-laceraciones",
daicmatbl_victim_infeccion.infeccion,
daicmatbl_victim_quemadura.quemadura,
daicmatbl_victim_fuezapertenece."Fueza publica pertenece"
FROM
daicmatbl_victim left join daicma_translation on daicmatbl_victim.condicion = daicma_translation.keyvalue
left join daicma_translation daicma_translation1 on daicmatbl_victim.genero = daicma_translation1.keyvalue
left join daicma_translation daicma_translation2 on daicmatbl_victim.estado = daicma_translation2.keyvalue
left join daicma_translation daicma_translation3 on daicmatbl_victim.actividad = daicma_translation3.keyvalue
left join daicmatbl_victim_amputacionfinal on daicmatbl_victim.victim_guid = daicmatbl_victim_amputacionfinal."Victim_GUID"
left join daicmatbl_victim_amputacioninicial on daicmatbl_victim.victim_guid = daicmatbl_victim_amputacioninicial."Victim_GUID"
left join daicmatbl_victim_afectacionauditiva on daicmatbl_victim.victim_guid = daicmatbl_victim_afectacionauditiva."Victim_GUID"
left join daicmatbl_victim_afectacionvisual on daicmatbl_victim.victim_guid = daicmatbl_victim_afectacionvisual."Victim_GUID"
left join daicmatbl_victim_esquirla on daicmatbl_victim.victim_guid = daicmatbl_victim_esquirla."Victim_GUID"
left join daicmatbl_victim_fractura on daicmatbl_victim.victim_guid = daicmatbl_victim_fractura."Victim_GUID"
left join daicmatbl_victim_heridaslaceraciones on daicmatbl_victim.victim_guid = daicmatbl_victim_heridaslaceraciones."Victim_GUID"
left join daicmatbl_victim_infeccion on daicmatbl_victim.victim_guid = daicmatbl_victim_infeccion."Victim_GUID"
left join daicmatbl_victim_quemadura on daicmatbl_victim.victim_guid = daicmatbl_victim_quemadura."Victim_GUID"
left join daicmatbl_victim_fuezapertenece on daicmatbl_victim.victim_guid = daicmatbl_victim_fuezapertenece."Victim_GUID";
drop table if EXISTS daicmatbl_link_victim_accident cascade;
CREATE table  daicmatbl_link_victim_accident AS
SELECT 
  link.link_guid, 
  link.approval_state, 
  link.from_guid AS victim_guid, 
  link.from_link_type, 
  link.to_guid AS accident_guid, 
  link.to_link_type
FROM 
  public.link
WHERE 
  link.approval_state = 'APPROVED' AND 
  link.from_link_type = 'VICTIM' AND 
  link.to_link_type = 'ACCIDENT';
drop table if EXISTS daicmatbl_victim3 cascade;
CREATE table  daicmatbl_victim3 AS
SELECT 
  daicmatbl_victim2.apellidos, 
  daicmatbl_victim2.nombres, 
  daicmatbl_victim2."numero de identificación", 
  daicmatbl_victim2.direccion, 
  daicmatbl_victim2."fecha de nacimiento", 
  daicmatbl_victim2.condicion, 
  daicmatbl_victim2.genero, 
  daicmatbl_victim2.estado, 
  daicmatbl_victim2."otra actividad", 
  daicmatbl_victim2."reporte medico", 
  daicmatbl_victim2.victim_guid, 
  daicmatbl_victim2.id_imsma_victima, 
  daicmatbl_victim2.actividad, 
daicmatbl_victim2."amputación-pérdida final", 
daicmatbl_victim2."amputación-pérdida inicial", 
daicmatbl_victim2."afectación auditiva", 
daicmatbl_victim2."afectación visual", 
daicmatbl_victim2.esquirla, 
daicmatbl_victim2.fractura, 
daicmatbl_victim2."Heridas-laceraciones", 
daicmatbl_victim2.infeccion, 
daicmatbl_victim2.quemadura,
  daicmatbl_victim_comunidad.comunidad, 
  daicmatbl_victim_etnia.etnia, 
  daicmatbl_victim_otrotipodocumento."otro tipo de documento", 
  daicmatbl_victim_pertenenciagrupoetnico."pertenencia a un grupo etnico", 
  daicmatbl_victim_rangoedad."rango de edad", 
  daicmatbl_victim_resguardoconsejocomunitario."resguardo consejo comunitario", 
  daicmatbl_victim_telefonocontacto."telefono de contacto", 
  daicmatbl_victim_tipodocumento."tipo de documento", 
  daicmatbl_victim_verificadoregistraduria."verificado registraduria",
daicmatbl_victim2."Fueza publica pertenece"
  FROM
daicmatbl_victim2 left join daicmatbl_victim_comunidad on daicmatbl_victim2.victim_guid = daicmatbl_victim_comunidad."Victim_GUID"
left join daicmatbl_victim_etnia on daicmatbl_victim2.victim_guid = daicmatbl_victim_etnia."Victim_GUID"
left join daicmatbl_victim_otrotipodocumento on daicmatbl_victim2.victim_guid = daicmatbl_victim_otrotipodocumento."Victim_GUID" 
left join daicmatbl_victim_pertenenciagrupoetnico on daicmatbl_victim2.victim_guid = daicmatbl_victim_pertenenciagrupoetnico."Victim_GUID"
left join daicmatbl_victim_rangoedad on daicmatbl_victim2.victim_guid =  daicmatbl_victim_rangoedad."Victim_GUID"
left join daicmatbl_victim_resguardoconsejocomunitario on daicmatbl_victim2.victim_guid = daicmatbl_victim_resguardoconsejocomunitario."Victim_GUID"
left join daicmatbl_victim_telefonocontacto on daicmatbl_victim2.victim_guid = daicmatbl_victim_telefonocontacto."Victim_GUID"
left join daicmatbl_victim_tipodocumento on daicmatbl_victim2.victim_guid = daicmatbl_victim_tipodocumento."Victim_GUID"
left join daicmatbl_victim_verificadoregistraduria on daicmatbl_victim2.victim_guid =  daicmatbl_victim_verificadoregistraduria."Victim_GUID";
drop table if EXISTS daicmatbl_victim_final cascade;
CREATE table  daicmatbl_victim_final AS
SELECT 
  daicmatbl_accident_final."tipo de accidente", 
  daicmatbl_accident_final.departamento, 
  daicmatbl_accident_final.municipio, 
  daicmatbl_accident_final.sitio, 
 daicmatbl_accident_final.tipologia, 
  daicmatbl_accident_final."Fecha del accidente", 
  daicmatbl_accident_final."Coordenadas tomadas con", 
  daicmatbl_accident_final.latitude, 
  daicmatbl_accident_final.longitude, 
  daicmatbl_accident_final.cod_dane_muni, 
  daicmatbl_accident_final.cod_dane_depto, 
  daicmatbl_accident_final."Tipo de lugar", 
  daicmatbl_accident_final."Presunto actor responsable", 
  daicmatbl_accident_final."descripción", 
  daicmatbl_accident_final."Tipo de área", 
  daicmatbl_accident_final."id_imsma evento", 
  daicmatbl_accident_final.accident_guid, 
  daicmatbl_victim3.apellidos, 
  daicmatbl_victim3.nombres, 
  daicmatbl_victim3."tipo de documento", 
  daicmatbl_victim3."otro tipo de documento", 
  daicmatbl_victim3."numero de identificación", 
  daicmatbl_victim3.direccion, 
  daicmatbl_victim3."telefono de contacto", 
  daicmatbl_victim3."fecha de nacimiento", 
  daicmatbl_victim3.condicion, 
  daicmatbl_victim3.genero, 
  daicmatbl_victim3.estado, 
  daicmatbl_victim3."rango de edad", 
  daicmatbl_victim3.actividad, 
  daicmatbl_victim3."otra actividad", 
  daicmatbl_victim3."reporte medico", 
  daicmatbl_victim3."pertenencia a un grupo etnico", 
  daicmatbl_victim3.etnia, 
  daicmatbl_victim3.comunidad, 
  daicmatbl_victim3."resguardo consejo comunitario", 
  daicmatbl_victim3."verificado registraduria", 
  daicmatbl_victim3.victim_guid, 
  daicmatbl_victim3.id_imsma_victima,
daicmatbl_victim3."amputación-pérdida final",
daicmatbl_victim3."amputación-pérdida inicial",
daicmatbl_victim3."afectación auditiva",
daicmatbl_victim3."afectación visual",
daicmatbl_victim3.esquirla,
daicmatbl_victim3.fractura,
daicmatbl_victim3."Heridas-laceraciones",
daicmatbl_victim3.infeccion,
daicmatbl_victim3.quemadura,
daicmatbl_victim3."Fueza publica pertenece"
FROM
(daicmatbl_victim3 left join daicmatbl_link_victim_accident on daicmatbl_victim3.victim_guid = daicmatbl_link_victim_accident.victim_guid)  
left join daicmatbl_accident_final on daicmatbl_link_victim_accident.accident_guid = daicmatbl_accident_final.accident_guid;
--final victimas--------------------------------------------------------------------------------
--Base mensual de eventos-----------------------------------------------------------------------
drop table if EXISTS daicmatbl_datos_eventos;
CREATE TABLE daicmatbl_datos_eventos
(
  "Tipo de evento" text,
departamento character varying(125),
municipio character varying(125),
sitio character varying(125),
tipologia character varying(125),
"Fecha del evento" timestamp without time zone,
  "Coordenadas tomadas con" text,
  latitude numeric(18,16),
  longitude numeric(19,16),
  cod_dane_depto text,
  cod_dane_muni text,
  "Tipo de lugar" text,
   "Presunto actor responsable" text,
  descripcion text,
    "Tipo de area" character varying(50),
    id_imsma_evento character varying(50),
 estatus text,
 hazard_guid character varying(38),
 "cantidad de artefactos" numeric(21,0)
);
insert into daicmatbl_datos_eventos
(
  "Tipo de evento",
departamento,
municipio,
sitio,
tipologia,
"Fecha del evento",
"Coordenadas tomadas con",
latitude,
longitude,
cod_dane_depto,
cod_dane_muni,
"Tipo de lugar",
"Presunto actor responsable",
descripcion,
"Tipo de area",
id_imsma_evento,
estatus,
hazard_guid,
"cantidad de artefactos"
)
SELECT 
  daicma_hazard_incidentes."Tipo de evento", 
  daicma_hazard_incidentes.departamento, 
  daicma_hazard_incidentes.municipio, 
  daicma_hazard_incidentes.sitio, 
daicma_hazard_incidentes.tipologia, 
  daicma_hazard_incidentes."Fecha del evento", 
  daicma_hazard_incidentes."Coordenadas tomadas con", 
  daicma_hazard_incidentes.latitude, 
  daicma_hazard_incidentes.longitude, 
  daicma_hazard_incidentes.cod_dane_depto, 
  daicma_hazard_incidentes.cod_dane_muni, 
  daicma_hazard_incidentes."Tipo de lugar", 
  daicma_hazard_incidentes."Presunto actor responsable", 
  daicma_hazard_incidentes.descripcion, 
  daicma_hazard_incidentes."Tipo de área", 
  daicma_hazard_incidentes."id_imsma evento", 
  daicma_hazard_incidentes.estatus, 
  daicma_hazard_incidentes.hazard_guid, 
  daicma_hazard_incidentes."Cantidad de artefactos"  
FROM 
  daicma_hazard_incidentes
WHERE 
  daicma_hazard_incidentes."Tipo de evento" NOT LIKE 'Accidente por MAP, MUSE o AEI';
insert into daicmatbl_datos_eventos
(
  "Tipo de evento",
departamento,
municipio,
sitio,
tipologia,
"Fecha del evento",
"Coordenadas tomadas con",
latitude,
longitude,
cod_dane_depto,
cod_dane_muni,
"Tipo de lugar",
"Presunto actor responsable",
descripcion,
"Tipo de area",
id_imsma_evento,
hazard_guid
)
SELECT 
  daicmatbl_accident_final."tipo de accidente", 
  daicmatbl_accident_final.departamento, 
  daicmatbl_accident_final.municipio, 
  daicmatbl_accident_final.sitio, 
  daicmatbl_accident_final.tipologia, 
  daicmatbl_accident_final."Fecha del accidente", 
  daicmatbl_accident_final."Coordenadas tomadas con", 
  daicmatbl_accident_final.latitude, 
  daicmatbl_accident_final.longitude,  
  daicmatbl_accident_final.cod_dane_depto, 
  daicmatbl_accident_final.cod_dane_muni,
  daicmatbl_accident_final."Tipo de lugar", 
  daicmatbl_accident_final."Presunto actor responsable", 
  daicmatbl_accident_final."descripción", 
  daicmatbl_accident_final."Tipo de área", 
  daicmatbl_accident_final."id_imsma evento", 
  daicmatbl_accident_final.accident_guid
FROM 
  daicmatbl_accident_final;
UPDATE daicmatbl_datos_eventos
   SET estatus=daicma_hazard_incidentes.estatus
from daicma_hazard_incidentes
 WHERE (daicmatbl_datos_eventos.id_imsma_evento = daicma_hazard_incidentes."id_imsma evento");